/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.autoplot.PlotStylePanel;
import org.autoplot.dom.PlotElement;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.graph.Renderer;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public final class BoundsStylePanel
extends JPanel
implements PlotStylePanel.StylePanel {
    Renderer renderer;
    BindingGroup elementBindingContext;
    private String control = "";
    public static final String PROP_CONTROL = "control";
    private ColorEditor colorEditor1;
    private ColorEditor colorEditor2;
    private JPanel colorPanel;
    private JPanel fillColorPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JCheckBox polarCheckBox;
    private JComboBox<String> textureComboBox;

    public BoundsStylePanel() {
        this.initComponents();
        this.colorEditor1.setValue((Object)Color.BLACK);
        this.colorPanel.add(this.colorEditor1.getSmallEditor());
        this.colorEditor1.addPropertyChangeListener(evt -> this.update());
        this.colorEditor2.setValue((Object)Color.BLACK);
        this.fillColorPanel.add(this.colorEditor2.getSmallEditor());
        this.colorEditor2.addPropertyChangeListener(evt -> this.update());
        this.validate();
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        String oldControl = this.control;
        this.control = control;
        this.renderer.setControl(control);
        this.updateGUI(this.renderer);
        this.firePropertyChange(PROP_CONTROL, oldControl, control);
    }

    private void update() {
        String c;
        String oldValue = this.control;
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("color", Renderer.encodeColorControl((Color)((Color)this.colorEditor1.getValue())));
        controls.put("fillColor", Renderer.encodeColorControl((Color)((Color)this.colorEditor2.getValue())));
        controls.put("fillTexture", String.valueOf(this.textureComboBox.getSelectedItem()));
        controls.put("polar", Renderer.encodeBooleanControl((boolean)this.polarCheckBox.isSelected()));
        this.control = c = Renderer.formatControl(controls);
        this.firePropertyChange(PROP_CONTROL, oldValue, c);
    }

    private void updateGUI(Renderer renderer) {
        this.control = renderer.getControl();
        this.colorEditor1.setValue((Object)renderer.getColorControl("color", (Color)this.colorEditor1.getValue()));
        this.colorEditor2.setValue((Object)renderer.getColorControl("fillColor", (Color)this.colorEditor2.getValue()));
        this.textureComboBox.setSelectedItem(renderer.getControl("fillTexture", ""));
        this.polarCheckBox.setSelected(renderer.getBooleanControl("polar", false));
    }

    @Override
    public void doElementBindings(PlotElement element) {
        this.renderer = element.getController().getRenderer();
        this.updateGUI(this.renderer);
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)element, (Property)BeanProperty.create((String)"renderControl"), (Object)this, (Property)BeanProperty.create((String)PROP_CONTROL)));
        if (this.elementBindingContext != null) {
            this.releaseElementBindings();
        }
        bc.bind();
        this.repaint();
        this.elementBindingContext = bc;
    }

    @Override
    public void releaseElementBindings() {
        if (this.elementBindingContext != null) {
            this.elementBindingContext.unbind();
            this.elementBindingContext = null;
        }
    }

    private void initComponents() {
        this.colorEditor1 = new ColorEditor();
        this.colorEditor2 = new ColorEditor();
        this.jLabel2 = new JLabel();
        this.colorPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.fillColorPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.textureComboBox = new JComboBox();
        this.polarCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder("Bounds"));
        this.jLabel2.setText("Color:");
        this.colorPanel.setLayout(new BorderLayout());
        this.jLabel1.setText("Fill Color:");
        this.fillColorPanel.setLayout(new BorderLayout());
        this.jLabel3.setText("Fill Texture:");
        this.textureComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "solid", "hash", "backhash", "crosshash"}));
        this.textureComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BoundsStylePanel.this.textureComboBoxItemStateChanged(evt);
            }
        });
        this.polarCheckBox.setText("polar");
        this.polarCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoundsStylePanel.this.polarCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fillColorPanel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textureComboBox, 0, 1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.polarCheckBox).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.colorPanel, -2, 100, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(134, 134, 134)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2)).addComponent(this.colorPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.fillColorPanel, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.textureComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.polarCheckBox).addContainerGap(39, Short.MAX_VALUE)));
    }

    private void textureComboBoxItemStateChanged(ItemEvent evt) {
        this.update();
    }

    private void polarCheckBoxActionPerformed(ActionEvent evt) {
        this.update();
    }
}

